/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.traceroute;

import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.common.OID;
import ibm.nways.jdm.snmp.SnmpAPI;
import ibm.nways.jdm.snmp.SnmpPDU;
import ibm.nways.jdm.snmp.SnmpPDUException;
import ibm.nways.jdm.snmp.SnmpSession;
import ibm.nways.jdm.snmp.SnmpSocketException;
import ibm.nways.jdm.snmp.SnmpUnknownHostException;
import ibm.nways.jdm.snmp.SnmpVarBind;
import ibm.nways.jdm.traceroute.RouteTable;
import ibm.nways.jdm.traceroute.SnmpRouteTable;
import java.io.Serializable;
import java.util.Vector;

public class SnmpRouteTable
extends RouteTable {
    protected String setCommunityName = "public";
    protected int retries = 3;
    protected int timeoutMsec = 1000;
    protected int port = 161;
    private static final boolean debug = false;

    public SnmpRouteTable(IPAddress iPAddress, String string) throws SnmpUnknownHostException, SnmpSocketException, Exception {
        super(iPAddress, string);
        this.routeTable = new Vector();
        this.initialize();
    }

    protected void initialize() throws SnmpUnknownHostException, SnmpSocketException, SnmpPDUException, Exception {
        block9: {
            SnmpSession snmpSession = null;
            try {
                try {
                    SnmpAPI.initialize();
                    snmpSession = SnmpSession.open((String)this.ipAddress.toString(), (String)this.communityName, (String)this.setCommunityName, (int)this.retries, (int)this.timeoutMsec, (int)this.port);
                    SnmpPDU snmpPDU = snmpSession.makePDU();
                    snmpPDU.operation = 1;
                    OID oID = new OID("1.3.6.1.2.1.4.21.1.1");
                    snmpPDU.addVarBind(oID);
                    snmpPDU.addVarBind("1.3.6.1.2.1.4.21.1.2");
                    snmpPDU.addVarBind("1.3.6.1.2.1.4.21.1.3");
                    snmpPDU.addVarBind("1.3.6.1.2.1.4.21.1.4");
                    snmpPDU.addVarBind("1.3.6.1.2.1.4.21.1.5");
                    snmpPDU.addVarBind("1.3.6.1.2.1.4.21.1.6");
                    snmpPDU.addVarBind("1.3.6.1.2.1.4.21.1.7");
                    snmpPDU.addVarBind("1.3.6.1.2.1.4.21.1.8");
                    snmpPDU.addVarBind("1.3.6.1.2.1.4.21.1.9");
                    snmpPDU.addVarBind("1.3.6.1.2.1.4.21.1.10");
                    snmpPDU.addVarBind("1.3.6.1.2.1.4.21.1.11");
                    snmpPDU.addVarBind("1.3.6.1.2.1.4.21.1.12");
                    snmpPDU.addVarBind("1.3.6.1.2.1.4.21.1.13");
                    boolean bl = false;
                    while (!bl) {
                        SnmpPDU snmpPDU2 = snmpSession.send(snmpPDU);
                        if (snmpPDU2.errorStatus == 0) {
                            OID oID2 = snmpPDU2.varBindAt(0).getOID();
                            if (oID2.startsWith(oID)) {
                                this.addRow(snmpPDU2);
                                snmpPDU = snmpPDU2;
                                snmpPDU.operation = 1;
                                continue;
                            }
                            bl = true;
                            continue;
                        }
                        throw new SnmpPDUException(snmpPDU2);
                    }
                }
                catch (SnmpUnknownHostException snmpUnknownHostException) {
                    throw snmpUnknownHostException;
                }
                catch (SnmpSocketException snmpSocketException) {
                    throw snmpSocketException;
                }
                catch (Exception exception) {
                    throw exception;
                }
                Object var3_10 = null;
                if (snmpSession == null) break block9;
            }
            catch (Throwable throwable) {
                block10: {
                    Object var3_11 = null;
                    if (snmpSession == null) break block10;
                    snmpSession.close();
                }
                throw throwable;
            }
            snmpSession.close();
        }
    }

    private void addRow(SnmpPDU snmpPDU) {
        if (snmpPDU.errorStatus == 0) {
            Vector<Serializable> vector = new Vector<Serializable>(snmpPDU.varBindListSize());
            int n = 0;
            while (n < snmpPDU.varBindListSize()) {
                SnmpVarBind snmpVarBind = snmpPDU.varBindAt(n);
                Serializable serializable = snmpVarBind.getVar();
                vector.addElement(serializable);
                ++n;
            }
            this.routeTable.addElement(new SnmpRouteTableRow(vector));
        }
    }

    public class SnmpRouteTableRow
    extends RouteTable.RouteTableRow {
        private Vector row;

        public SnmpRouteTableRow(Vector vector) {
            SnmpRouteTable.this = SnmpRouteTable.this;
            this.row = vector;
            this.row.insertElementAt(new 1(), 0);
        }

        public IPAddress getIpRouteDest() {
            return (IPAddress)this.row.elementAt(1);
        }

        public Integer getIpRouteIfIndex() {
            return (Integer)this.row.elementAt(2);
        }

        public Integer getIpRouteMetric1() {
            return (Integer)this.row.elementAt(3);
        }

        public Integer getIpRouteMetric2() {
            return (Integer)this.row.elementAt(4);
        }

        public Integer getIpRouteMetric3() {
            return (Integer)this.row.elementAt(5);
        }

        public Integer getIpRouteMetric4() {
            return (Integer)this.row.elementAt(6);
        }

        public IPAddress getIpRouteNextHop() {
            return (IPAddress)this.row.elementAt(7);
        }

        public Integer getIpRouteType() {
            return (Integer)this.row.elementAt(8);
        }

        public Integer getIpRouteProto() {
            return (Integer)this.row.elementAt(9);
        }

        public Integer getIpRouteAge() {
            return (Integer)this.row.elementAt(10);
        }

        public IPAddress getIpRouteMask() {
            return (IPAddress)this.row.elementAt(11);
        }

        public Integer getIpRouteMetric5() {
            return (Integer)this.row.elementAt(12);
        }

        public OID getIpRouteInfo() {
            return (OID)this.row.elementAt(13);
        }
    }
}

